﻿var copyDistribution = {
    context: $(".v-copyDistribution"),
    datatable: null,
    initialize: function () {
        $(".h-surveys", copyDistribution.context).a4autocomplete({
            preloadData: true,
            ajaxAction: a4.getAction("GetSurveysForAutoComplete", "Home", "Survey"),
            ajaxParams: { withDistributionsOnly: true },
            categoryProperty: "Folder",
            altValueField: $("#SourceSurveyId", copyDistribution.context),
            select: function (event, data) {
                if (copyDistribution.datatable) {
                    copyDistribution.datatable.a4datatable("option", "ajaxParams", { "surveyId": data.item.Value });
                    copyDistribution.datatable.a4datatable("refresh", true);
                }
                else {
                    copyDistribution.initializeDataTable(data.item.Value);
                }
            }
        });

        var surveyId = $("#SourceSurveyId", copyDistribution.context).val();

        if (surveyId && surveyId > 0) {
            copyDistribution.initializeDataTable(surveyId);
        }
    },
    initializeDataTable: function (surveyId) {
        this.datatable = $(".h-distributionsTable", copyDistribution.context).a4datatable({
            displayColumnSelector: false,
            displaySearchBox: false,
            allowRowSelection: true,
            ajaxAction: a4.getAction("GetDistributionsForCopy", "Distribute", "Survey"),
            ajaxParams: { surveyId: surveyId },
            defaultSorting: "Id",
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Key": true },
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "Width": "25%" },
                { "Name": "Type", "Title": resources.Type, "Data": "TypeEnum", "Type": "enum", "EnumType": "DistributionType" },
                { "Name": "SendDate", "Title": resources.SendDate, "Data": "SendDate", "Type": "date", "Width": "150px" },
                { "Name": "Status", "Title": resources.Status, "Data": "StatusEnum", "Type": "enum", "EnumType": "TaskStatus" },
            ],
            selectRow: function (event, data) {
                copyDistribution.updateSelectedDistributions(data.selectedRows);
            },
            selectAll: function (event, data) {
                copyDistribution.updateSelectedDistributions(data.selectedRows);
            }
        });
    },
    updateSelectedDistributions: function (selectedRows) {
        $("#DistributionIds", copyDistribution.context).val(_.pluck(selectedRows, "Id").join());
    }
}

$(document).ready(function () {
    if (copyDistribution.context.length > 0) {
        copyDistribution.initialize();
    }
});